/* Copyright (C) 2016-2018 RealVNC Ltd.  All Rights Reserved.
 */

/* This is sample code intended to demonstrate part of the
 * VNC Mobile Solution SDK. It is not intended as a production-ready
 * component.
 */

#include "BaseDecoderLogHandler.h"

BaseDecoderLogHandler::BaseDecoderLogHandler(
        const VNCCommonDecoderSupportingAPI& supportingAPI,
        VNCCommonDecoderFrameworkContext frameworkContext)

    :   mSupportingAPI(supportingAPI),
        mFrameworkContext(frameworkContext)
{
}

void BaseDecoderLogHandler::writeRaw(
        const vnccommon::LogLevel level,
        const char *const tag,
        const char *const text)
{
    mSupportingAPI.vncCommonDecoderSupportingAPILog(
            mFrameworkContext,
            static_cast<vnc_int32_t>(level),
            tag,
            text);
}

